package tech.poool.engage.core.helpers

internal fun snakeToCamelCase(name: String): String {
    val pattern = "_[a-z]".toRegex()
    return name.lowercase().replace(pattern) {
        it.value.last().uppercase()
    }
}

internal fun camelToSnakeCase(name: String): String {
    val pattern = "[A-Z]".toRegex()
    return name.replace(pattern) {
        "_${it.value.lowercase()}"
    }
}

internal fun replace(text: String, replaces: Map<String, String?>): String {
    return replaces.entries.fold(text) { acc, (key, value) ->
        acc.replace("{$key}", value.toString())
    }
}
