package tech.poool.engage.compose

import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.wrapContentHeight
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import tech.poool.engage.core.shared.LocalEngage

@Composable
fun EngagePlaceholder (
    id: String,
    modifier: Modifier = Modifier,
) {
    val (_, targets) = LocalEngage.current

    val elements = targets[id]

    elements?.let { element -> element.forEach {
        Element(
            element = it,
            modifier = modifier.fillMaxWidth().wrapContentHeight(),
        )
    } }
}
