package tech.poool.engage.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import tech.poool.engage.ClickEvent
import tech.poool.engage.DestroyEvent
import tech.poool.engage.ErrorEvent
import tech.poool.engage.FieldError
import tech.poool.engage.FormEvent
import tech.poool.engage.ReadyEvent
import tech.poool.engage.SeenEvent
import tech.poool.engage.network.responses.EngageElement
import tech.poool.engage.core.shared.LocalEngage
import tech.poool.engage.onClick
import tech.poool.engage.onDestroy
import tech.poool.engage.onError
import tech.poool.engage.onFormSubmit
import tech.poool.engage.onReady
import tech.poool.engage.onSeen

@Composable
fun EngageElement (
    slug: String,
    modifier: Modifier = Modifier,
    onReady: ((ReadyEvent) -> Unit)? = null,
    onSeen: ((SeenEvent) -> Unit)? = null,
    onClick: ((ClickEvent) -> Unit)? = null,
    onFormSubmit: (suspend (FormEvent) -> List<FieldError>?)? = null,
    onDestroy: ((DestroyEvent) -> Unit)? = null,
    onError: ((ErrorEvent) -> Unit)? = null,
) {
    val (engage) = LocalEngage.current
    var element by remember { mutableStateOf<EngageElement?>(null) }

    LaunchedEffect(Unit) {
        engage
            ?.onReady { onReady?.invoke(it) }
            ?.onSeen { onSeen?.invoke(it) }
            ?.onClick { onClick?.invoke(it) }
            ?.onFormSubmit { return@onFormSubmit onFormSubmit?.invoke(it) }
            ?.onDestroy { onDestroy?.invoke(it) }
            ?.onError { onError?.invoke(it) }

        engage?.createElement(slug, onDisplay = {
            element = it
        })
    }

    element?.let {
        Element(modifier = modifier, element = it)
    }
}
