package tech.poool.engage

import tech.poool.commons.events.BaseEventTypes

enum class EngageEvents: BaseEventTypes {
    READY,
    SEEN,
    CLICK,
    FORM_SUBMIT,
    DESTROY,
    ERROR
}

data class ElementData(
    var name: String,
    var slug: String? = null,
)

data class FieldError (
    override val fieldKey: String = "",
    override val message: String? = null,
    override val emailExists: Boolean? = false,
): tech.poool.commons.oak.data.FieldError()

abstract class EngageEventData {
    abstract val element: ElementData
}

data class ReadyEvent (
    override var element: ElementData,
): EngageEventData()

data class SeenEvent (
    override var element: ElementData,
): EngageEventData()

data class ClickEvent(
    var id: String,
    var type: String,
    var url: String,
    var name: String,

    override var element: ElementData,
): EngageEventData()

data class FormEvent(
    var fields: Map<String, Any?>,
    var valid: Map<String, Boolean>,

    override var element: ElementData,
): EngageEventData()

data class DestroyEvent(
    var buttonId: String?,

    override var element: ElementData,
): EngageEventData()

data class ErrorEvent(
    var message: String,

    override var element: ElementData,
): EngageEventData()
