package tech.poool.engage

import com.google.gson.Gson

fun Engage.off(event: EngageEvents): Engage {
    manager.off(event)

    return this
}

fun Engage.onReady(once: Boolean = false, callback: (ReadyEvent) -> Unit): Engage {
    manager.on(EngageEvents.READY, once, callbackSync = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, ReadyEvent::class.java)

        callback(eventData)
    })

    return this
}

fun Engage.onSeen(once: Boolean = false, callback: (SeenEvent) -> Unit): Engage {
    manager.on(EngageEvents.SEEN, once, callbackSync = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, SeenEvent::class.java)

        callback(eventData)
    })

    return this
}

fun Engage.onClick(once: Boolean = false, callback: (ClickEvent) -> Unit): Engage {
    manager.on(EngageEvents.CLICK, once, callbackSync = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, ClickEvent::class.java)

        callback(eventData)
    })

    return this
}

fun Engage.onFormSubmit(
    once: Boolean = false,
    callback: suspend (FormEvent) -> List<FieldError>?
): Engage {
    manager.on(EngageEvents.FORM_SUBMIT, once, callback = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, FormEvent::class.java)

        callback(eventData)
    })

    return this
}

fun Engage.onDestroy(once: Boolean = false, callback: (DestroyEvent) -> Unit): Engage {
    manager.on(EngageEvents.DESTROY, once, callbackSync = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, DestroyEvent::class.java)

        callback(eventData)
    })

    return this
}

fun Engage.onError(once: Boolean = false, callback: (ErrorEvent) -> Unit): Engage {
    manager.on(EngageEvents.ERROR, once, callbackSync = { data ->
        val json = Gson().toJson(data)
        val eventData = Gson().fromJson(json, ErrorEvent::class.java)

        callback(eventData)
    })

    return this
}
