package tech.poool.commons.texts

import tech.poool.commons.helpers.replace
import tech.poool.commons.config.BaseConfig
import tech.poool.commons.config.get
import tech.poool.commons.variables.BaseVariables

internal open class BaseTexts (
    protected val baseData: Map<String, Map<String, String?>> = mapOf(),
    private val config: BaseConfig? = null,
    private val variables: BaseVariables? = null,
) {
    protected val customData: MutableMap<String, MutableMap<String, String?>> = mutableMapOf()
    protected val readOnlies: MutableList<String> = mutableListOf()

    protected fun getLocale(): String = config?.get<String>("locale") ?: "fr"

    fun get (
        key: String,
        locale: String? = null,
        replacers: Map<String, String?> = mapOf()
    ): String {
        val finalLocale: String = locale ?: getLocale()
        val text = customData[finalLocale]?.let { it[key] } ?: baseData[finalLocale]?.let { it[key] }

        val finalReplacer = variables?.getAll()?.plus(replacers) ?: replacers

        return replace((text ?: key).toString(), finalReplacer)
    }

    fun getAll(locale: String? = null): Map<String, String?> {
        val finalLocale: String = locale ?: getLocale()
        return (baseData[finalLocale] ?: mapOf()).plus(customData[finalLocale] ?: mapOf())
    }

    fun setVal(key: String, value: String?, readOnly: Boolean?, locale: String?): Boolean {
        val finalLocale: String = locale ?: getLocale()

        if (readOnlies.contains(key)) {
            return false
        }

        if (customData[finalLocale] == null) {
            customData[finalLocale] = mutableMapOf()
        }

        val texts = customData[finalLocale] ?: customData[DEFAULT_LOCALE]

        texts!![key] = value

        if (readOnly != null && readOnly) {
            readOnlies.add(key)
        }

        return true
    }

    fun reset() {
        readOnlies.clear()
        customData.clear()
    }

    companion object {
        const val DEFAULT_LOCALE = "fr"
    }
}
