package tech.poool.commons.oak.network

import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import tech.poool.commons.oak.data.ColorPaletteDefinition
import tech.poool.commons.oak.data.ColorPaletteDefinitionColor
import tech.poool.commons.oak.data.ColorPaletteDefinitionShadow
import tech.poool.commons.oak.data.ColorPaletteDefinitionShadowValue
import tech.poool.commons.oak.data.ColorPaletteDefinitionUnknown
import java.lang.reflect.Type

internal class PaletteDefinitionDeserializer : JsonDeserializer<ColorPaletteDefinition> {
    override fun deserialize(
        json: JsonElement,
        typeOfT: Type,
        context: JsonDeserializationContext
    ): ColorPaletteDefinition {
        val jsonObject = json.asJsonObject

        return when (jsonObject.get("type").asString) {
            "color", "image", "size" -> ColorPaletteDefinitionColor(
                value = jsonObject.get("value").asString,
                type = jsonObject.get("type").asString,
                key = jsonObject.get("key").asString,
                label = jsonObject.get("label")?.asString,
            )
            "shadow" -> ColorPaletteDefinitionShadow(
                value = context.deserialize(
                    jsonObject.get("value"),
                    ColorPaletteDefinitionShadowValue::class.java
                ),
                type = jsonObject.get("type").asString,
                key = jsonObject.get("key").asString,
                label = jsonObject.get("label")?.asString,
            )
            else -> ColorPaletteDefinitionUnknown(
                type = jsonObject.get("type").asString,
                key = jsonObject.get("key").asString,
                label = jsonObject.get("label")?.asString,
            )
        }
    }
}

