package tech.poool.commons.oak.network

import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import tech.poool.commons.oak.data.*
import java.lang.reflect.Type

internal class BlockDeserializer(
    private val additionalDeserializer: JsonDeserializer<BlockItem>? = null
) : JsonDeserializer<BlockItem> {
    override fun deserialize(
        json: JsonElement,
        typeOfT: Type,
        context: JsonDeserializationContext
    ): BlockItem {
        val jsonObject = json.asJsonObject

        return when (jsonObject.get("type").asString) {
            "row" -> BlockRowItem(
                cols = jsonObject.get("cols").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "col" -> BlockColItem(
                content = jsonObject.get("content").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },
                size = jsonObject.get("size")?.asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "title" -> BlockTitleItem(
                content = jsonObject.get("content").asString,
                headingLevel = jsonObject.get("headingLevel").asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "text" -> BlockTextItem(
                content = jsonObject.get("content").asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "button" -> BlockButtonItem(
                content = jsonObject.get("content").asString,
                url = jsonObject.get("url").asString,
                action = jsonObject.get("action").asString,
                event = jsonObject.get("event")?.asString,
                customId = jsonObject.get("customId")?.asString,
                fieldKey = jsonObject.get("fieldKey")?.asString,
                fieldValue = jsonObject.get("fieldValue")?.asString,
                fieldOperation = jsonObject.get("fieldOperation")?.asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "image" -> BlockImageItem(
                name = jsonObject.get("name").asString,
                url = jsonObject.get("url").asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "empty-space" -> BlockEmptySpaceItem(
                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "list" -> BlockListItem(
                fieldOptions = jsonObject.get("fieldOptions").asJsonArray.map {
                    context.deserialize(it, FieldOption::class.java)
                },

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "foldable" -> BlockFoldableItem(
                seeMore = jsonObject.get("seeMore").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },
                content = jsonObject.get("content").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },
                seeLess = jsonObject.get("seeLess").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "clickable" -> BlockClickableItem(
                content = jsonObject.get("content").asJsonArray.map {
                    context.deserialize(it, BlockItem::class.java)
                },
                url = jsonObject.get("url").asString,
                action = jsonObject.get("action").asString,
                event = jsonObject.get("event")?.asString,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            // Forms
            "text-field" -> BlockTextFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "password-field" -> BlockPasswordFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "phone-field" -> BlockPhoneFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "multiline-field" -> BlockMultilineFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "email-field" -> BlockEmailFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "date-field" -> BlockDateFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,
                minDate = if (json.asJsonObject.get("minDate")?.isJsonNull == true) null
                        else json.asJsonObject.get("minDate")?.asString ?: "",
                maxDate = if (json.asJsonObject.get("maxDate")?.isJsonNull == true) null
                        else json.asJsonObject.get("maxDate")?.asString ?: "",

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "select-field" -> BlockSelectFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,
                fieldOptions = jsonObject.get("fieldOptions")?.asJsonArray?.map {
                    context.deserialize(it, FormFieldOption::class.java)
                } ?: emptyList(),

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "radio-field" -> BlockRadioFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,
                fieldOptions = jsonObject.get("fieldOptions")?.asJsonArray?.map {
                    context.deserialize(it, FormFieldOption::class.java)
                } ?: emptyList(),

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "checkbox-field" -> BlockCheckboxFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            "hidden-field" -> BlockHiddenFieldItem(
                fieldName = jsonObject.get("fieldName")?.asString ?: "",
                fieldType = jsonObject.get("fieldType")?.asString ?: "",
                fieldKey = jsonObject.get("fieldKey")?.asString ?: "",
                fieldValue = jsonObject.get("fieldValue")?.asString ?: "",
                fieldPlaceholder = jsonObject.get("fieldPlaceholder")?.asString ?: "",
                fieldLabel = jsonObject.get("fieldLabel")?.asString ?: "",
                fieldRequired = jsonObject.get("fieldRequired")?.asBoolean ?: false,

                id = jsonObject.get("id")?.asString ?: "",
                type = jsonObject.get("type").asString,
                settings = context.deserialize(
                    jsonObject.get("settings"),
                    BlockSettings::class.java
                ),
                styles = context.deserialize(
                    jsonObject.get("styles"),
                    BlockStyles::class.java
                )
            )
            else -> additionalDeserializer?.deserialize(json, typeOfT, context)
                ?: BlockUnknownItem(
                    id = jsonObject.get("id").asString,
                    type = jsonObject.get("type").asString,

                    settings = context.deserialize(
                        jsonObject.get("settings"),
                        BlockSettings::class.java
                    ),
                    styles = context.deserialize(
                        jsonObject.get("styles"),
                        BlockStyles::class.java
                    )
                )
        }
    }
}
