package tech.poool.commons.oak.components

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import tech.poool.commons.compose.LocalForm
import tech.poool.commons.oak.data.BlockButtonItem
import tech.poool.commons.oak.data.BlockItem

@Composable
internal fun Field(
    block: BlockItem,
    content: @Composable () -> Unit,
) {
    val form = LocalForm.current

    val isFormRelated = remember(block) {
        block.type.contains("-field") ||
                (block is BlockButtonItem && block.action == "submit")
    }

    val displayable = remember(block, form.isSent) {
        if (!form.isSent)
            block.settings?.displayBeforeSubmit ?: true
        else
            block.settings?.displayAfterSubmit ?: !isFormRelated
    }

    if (!displayable) {
        return
    }

    content()
}
