package tech.poool.commons.oak.components

import android.graphics.Color
import android.view.ViewGroup
import android.widget.TextView
import androidx.compose.material3.MaterialTheme
import androidx.compose.runtime.Composable
import androidx.compose.ui.viewinterop.AndroidView
import androidx.core.text.HtmlCompat
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.compose.LocalForm
import tech.poool.commons.oak.data.BlockTextItem
import tech.poool.commons.oak.oakStyleToModifier
import tech.poool.commons.oak.renderVariables
import tech.poool.commons.oak.spToPx
import tech.poool.commons.oak.textAlignFromHtml

@Composable
internal fun BlockText() {
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockTextItem
    val formProvider = LocalForm.current

    // This is not enough as AnnotatedString adds a new line at the end of the text
    // when the text is wrapped in a <p> or <div>
    /*Text(
        text = AnnotatedString.fromHtml(block.content),
        modifier = Modifier.oakStyleToModifier(
            settings = block.settings,
            styles = block.styles
        ).fillMaxWidth(),
    )*/
    // So we have to use the old TextView to render html and trim it, effectively removing
    // the new line at the end of the text
    val textStyles = MaterialTheme.typography.bodyLarge
    val finalText = renderVariables(
        HtmlCompat
            .fromHtml(block.content, HtmlCompat.FROM_HTML_MODE_COMPACT),
        additional = formProvider.getFormTextReplacers()
    )

    AndroidView(
        factory = { context ->
            TextView(context).apply {
                layoutParams = ViewGroup.LayoutParams(
                    ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.WRAP_CONTENT
                )
                text = finalText
                setTextColor(Color.BLACK)
                textSize = textStyles.fontSize.value
                if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.P) {
                    lineHeight = spToPx(textStyles.lineHeight.value, context)
                }
                textAlignment = textAlignFromHtml(block.content)
            }
        },
        modifier = currentBlock.modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
            ),
        update = {
            it.text = finalText
        }
    )
}
