package tech.poool.commons.network.utils

import tech.poool.commons.network.PooolApiSignature
import okhttp3.Headers
import okhttp3.MediaType.Companion.toMediaType
import okhttp3.Request
import okhttp3.RequestBody
import okhttp3.RequestBody.Companion.toRequestBody
import org.json.JSONObject
import tech.poool.commons.network.PooolPlatform

internal class RequestBuilder(
    private var bundleId: String? = null,
    private var baseUrl: String,
    private var k: String,
) {
    private var method: String = "GET"
    private val signature: PooolApiSignature = PooolApiSignature(k = k)
    private var headersProvider: HeadersProvider = HeadersProvider()

    private var finalUrl: String = baseUrl
    private var headers: Headers = headersProvider.getPublicHeaders()
    private var body: JSONObject = JSONObject()
    private var useSignature: Boolean = false

    fun addMethod(method: String) = apply { this.method = method }

    fun addEndpoint(path: String) = apply { finalUrl = finalUrl.plus(path) }

    fun newHeader(platform: String) = apply {
        headers = HeadersProvider(platform).getPublicHeaders()
    }

    fun addBody(jsonBody: JSONObject?) = apply { body = jsonBody ?: body }

    fun useSignature(use: Boolean) = apply { useSignature = use }

    fun newBuilder(bdlId: String? = null, url: String? = null, k: String? = null) =
        RequestBuilder(bdlId ?: bundleId, url ?: baseUrl, k ?: this.k)

    fun build(): Request {
        val finalBody: RequestBody? =
            if (method != "GET") {
                body.toString().toRequestBody("application/json; charset=utf-8".toMediaType())
            } else {
                null
            }

        signature.method = method
        signature.url = finalUrl

        if (useSignature) {
            val sign = signature.generateSignature()
            headers = headersProvider.getAuthenticatedHeaders(
                bundleId ?: throw IllegalStateException("BundleId is required"),
                sign
            )
        }

        return Request.Builder()
            .method(method, finalBody)
            .headers(headers)
            .url(finalUrl)
            .build()
    }
}
