package tech.poool.commons.logger

import android.util.Log
import tech.poool.commons.config.BaseConfig
import tech.poool.commons.config.get

internal open class BaseLogger (
    private val config: BaseConfig? = null,
    private val tag: String = "Poool",
    private val scope: String = "CORE"
) {
    private fun isDebugEnabled(): Boolean = config?.get<Boolean>("debug") ?: false

    fun d(message: String, scope: String = this.scope) {
        if (!isDebugEnabled()) return

        Log.d(tag, "$scope: $message")
    }

    fun i(message: String, scope: String = this.scope) {
        if (!isDebugEnabled()) return

        Log.i(tag, "$scope: $message")
    }

    fun w(message: String, scope: String = this.scope) {
        if (!isDebugEnabled()) return

        Log.w(tag, "$scope: $message")
    }

    fun e(message: String, scope: String = this.scope) {
        if (!isDebugEnabled()) return

        Log.e(tag, "$scope: $message")
    }
}
