package tech.poool.commons.compose

import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.TextLayoutResult
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.TextUnit

//internal fun retrieveText(
//    paywallData: PaywallResponse,
//    paywallDataConfig: AccessDataConfig,
//    textKey: String,
//    replace: Map<String, String?> = mapOf(),
//): String {
//    val config = paywallDataConfig.config
//    val text = paywallDataConfig.texts.get(textKey)
//
//    val finalReplaces = mutableMapOf<String, String?>(
//        "app_name" to config.get("appName"),
//        "count" to paywallData.remaining.toString(),
//        "percent" to config.get<Int>("percent").toString(),
//    ) + replace
//
//    return replace(text, finalReplaces)
//}

@Composable
internal fun TranslatedText(
    /* Text params */
    modifier: Modifier = Modifier,
    color: Color = MaterialTheme.colorScheme.onBackground,
    fontSize: TextUnit = TextUnit.Unspecified,
    fontStyle: FontStyle? = null,
    fontWeight: FontWeight? = null,
    fontFamily: FontFamily? = null,
    letterSpacing: TextUnit = TextUnit.Unspecified,
    textDecoration: TextDecoration? = null,
    textAlign: TextAlign? = null,
    lineHeight: TextUnit = TextUnit.Unspecified,
    overflow: TextOverflow = TextOverflow.Clip,
    softWrap: Boolean = true,
    maxLines: Int = Int.MAX_VALUE,
    minLines: Int = 1,
    onTextLayout: (TextLayoutResult) -> Unit = {},
    style: TextStyle = LocalTextStyle.current,
    /* Text params */

    textKey: String,
    replace: Map<String, String?> = mapOf(),
) {
//    val appProvider = LocalApp.current
    val commons = LocalCommons.current
//    val paywallDataConfig = appProvider.paywallDataConfig!!

    val finalText = commons.texts?.get(textKey, replacers = replace) ?: textKey
//    val finalText = retrieveText(
//        paywallData = LocalViewModel.current.paywallData,
//        paywallDataConfig = paywallDataConfig,
//        textKey = textKey,
//        replace = replace,
//    )

    Text(
        text = finalText,
        modifier = modifier,
        color = color,
        fontSize = fontSize,
        fontStyle = fontStyle,
        fontWeight = fontWeight,
        fontFamily = fontFamily,
        letterSpacing = letterSpacing,
        textDecoration = textDecoration,
        textAlign = textAlign,
        lineHeight = lineHeight,
        overflow = overflow,
        softWrap = softWrap,
        maxLines = maxLines,
        minLines = minLines,
        onTextLayout = onTextLayout,
        style = style,
    )
}
