package tech.poool.engage.compose

import androidx.compose.material3.LocalTextStyle
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.text.TextLayoutResult
import androidx.compose.ui.text.TextStyle
import androidx.compose.ui.text.font.FontFamily
import androidx.compose.ui.text.font.FontStyle
import androidx.compose.ui.text.font.FontWeight
import androidx.compose.ui.text.style.TextAlign
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.text.style.TextOverflow
import androidx.compose.ui.unit.TextUnit
import tech.poool.commons.config.get
import tech.poool.engage.Engage
import tech.poool.engage.core.helpers.replace
import tech.poool.engage.core.shared.LocalEngage

internal fun retrieveText(
    engage: Engage,
    textKey: String,
    replace: Map<String, String?> = mapOf(),
): String {
    val config = engage.manager.engageViewModel.dataConfig.config
    val text = engage.manager.texts.get(textKey)

    val finalReplaces = mutableMapOf<String, String?>(
        "app_name" to config.get<String>("appName"),
        "appName" to config.get<String>("appName"),
    ) + replace

    return replace(text, finalReplaces)
}

@Composable
internal fun TranslatedText(
    /* Text params */
    modifier: Modifier = Modifier,
    color: Color = MaterialTheme.colorScheme.onBackground,
    fontSize: TextUnit = TextUnit.Unspecified,
    fontStyle: FontStyle? = null,
    fontWeight: FontWeight? = null,
    fontFamily: FontFamily? = null,
    letterSpacing: TextUnit = TextUnit.Unspecified,
    textDecoration: TextDecoration? = null,
    textAlign: TextAlign? = null,
    lineHeight: TextUnit = TextUnit.Unspecified,
    overflow: TextOverflow = TextOverflow.Clip,
    softWrap: Boolean = true,
    maxLines: Int = Int.MAX_VALUE,
    minLines: Int = 1,
    onTextLayout: (TextLayoutResult) -> Unit = {},
    style: TextStyle = LocalTextStyle.current,
    /* Text params */

    textKey: String,
    replace: Map<String, String?> = mapOf(),
) {
    val (engage) = LocalEngage.current

    val finalText = engage?.let { retrieveText(
        engage = engage,
        textKey = textKey,
        replace = replace,
    ) } ?: textKey

    Text(
        text = finalText,
        modifier = modifier,
        color = color,
        fontSize = fontSize,
        fontStyle = fontStyle,
        fontWeight = fontWeight,
        fontFamily = fontFamily,
        letterSpacing = letterSpacing,
        textDecoration = textDecoration,
        textAlign = textAlign,
        lineHeight = lineHeight,
        overflow = overflow,
        softWrap = softWrap,
        maxLines = maxLines,
        minLines = minLines,
        onTextLayout = onTextLayout,
        style = style,
    )
}
