package tech.poool.engage

import tech.poool.commons.texts.BaseTexts
import tech.poool.engage.locales.*

internal class EngageTexts (
    config: EngageConfig? = null,
    variables: EngageVariables? = null,
): BaseTexts(
    baseData = mapOf(
        "en" to EN,
        "fr" to FR,
    ),
    config = config,
    variables = variables,
) {
    fun setFromApi(texts: Map<String, String>) {
        texts.forEach { (key, value) ->
            setVal(key, value, false, null)
        }
    }
}
