package tech.poool.commons.styles

import tech.poool.commons.logger.BaseLogger

internal open class BaseStyles (
    protected val baseData: Map<String, Any?> = mapOf(),
    private val logger: BaseLogger? = null,
) {
    protected val readOnlies: MutableList<String> = mutableListOf()
    protected val customData: MutableMap<String, Any?> = mutableMapOf()

    fun getAll(): Map<String, Any?> {
        return baseData + customData
    }

    fun <T>get(key: String): T {
        return (customData[key] ?: baseData[key]) as T
    }

    fun <T>setVal (key: String, value: T, readOnly: Boolean? = false): Boolean {
        val camelCaseKey = normalizeKey(key)

        if (
            value == null ||
            (value is String && value.trim().isEmpty()) ||
            readOnlies.contains(camelCaseKey)
        ) {
            return false
        }

        if (
            camelCaseKey.contains("color$".toRegex(RegexOption.IGNORE_CASE)) &&
            (value !is String || value.length != 7)
        ) {
            logger?.w("Invalid color value: $value")

            return false
        }

        if (baseData.keys.contains(camelCaseKey)) {
//            TODO: throw exception if value type is wrong

            customData[camelCaseKey] = value

            if ((readOnly != null) && readOnly) {
                readOnlies.add(camelCaseKey)
            }

            return true
        }

        return false
    }

    fun reset() {
        readOnlies.clear()
        customData.clear()
    }

    protected fun normalizeKey(name: String): String {
        return name
            .replace("([-_][a-z])".toRegex(RegexOption.IGNORE_CASE)) { it.value.uppercase() }
            .replace("-", "")
            .replace("_", "")
    }
}
