package tech.poool.commons.oak.data

internal data class FormFieldOption(
    val title: String,
    val value: String,
)

internal data class FormError (
    val fields: List<FieldError>?
)

abstract class FieldError {
    abstract val fieldKey: String
    abstract val message: String?
    abstract val emailExists: Boolean?
}

internal data class BaseFieldError (
    override val fieldKey: String = "",
    override val message: String? = null,
    override val emailExists: Boolean? = null,
): FieldError()
