package tech.poool.commons.oak.components

import androidx.compose.runtime.Composable
import androidx.compose.runtime.remember
import tech.poool.commons.compose.LocalCommons
import tech.poool.commons.compose.LocalForm
import tech.poool.commons.config.get
import tech.poool.commons.oak.data.BlockItem
import tech.poool.commons.oak.getConditionalDisplay

@Composable
internal fun ShouldDisplay(
    block: BlockItem,
    textReplacers: Map<String, String>,
    content: @Composable () -> Unit,
) {
    val commons = LocalCommons.current
    val variables = commons.variables?.getAll()
    val form = LocalForm.current
    val formTextReplacers = form.getFormTextReplacers()

    val shouldDisplay = remember(
        block, textReplacers, formTextReplacers
    ) {
        getConditionalDisplay(
            block = block,
            context = commons.config?.get<List<String>?>("context"),
            group = commons.group,
            filters = commons.filters,
            variables = (variables?.plus(textReplacers) ?: textReplacers) + formTextReplacers,
        )
    }

    if (!shouldDisplay) {
        return
    }

    content()
}
