package tech.poool.commons.oak.components

import androidx.compose.foundation.background
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.size
import androidx.compose.foundation.shape.CircleShape
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.draw.clip
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.unit.dp
import coil.compose.AsyncImage
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.compose.LocalForm
import tech.poool.commons.oak.data.BlockListItem
import tech.poool.commons.oak.oakStyleToModifier
import tech.poool.commons.oak.renderVariables

@Composable
internal fun BlockList() {
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockListItem
    val formProvider = LocalForm.current

    Column(
        modifier = Modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
            )
            .fillMaxWidth()
    ) {
        block.fieldOptions.forEach { item ->
            Row(
                modifier = Modifier.fillMaxWidth(),
                verticalAlignment = Alignment.CenterVertically
            ) {
                block.settings?.bulletImage?.url?.let {
                    AsyncImage(model = it, contentDescription = "List bullet")
                } ?: Box(
                    modifier = Modifier
                        .padding(start = 8.dp, end = 8.dp)
                        .clip(CircleShape)
                        .size(6.dp)
                        .background(Color.Black)
                )

                Text(
                    text = renderVariables(
                        item.value,
                        additional = formProvider.getFormTextReplacers()
                    )
                )
            }
        }
    }
}
