package tech.poool.commons.oak.components

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.oak.data.BlockFoldableItem
import tech.poool.commons.oak.oakStyleToModifier

@Composable
internal fun BlockFoldable() {
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockFoldableItem

    var opened by remember { mutableStateOf(false) }

    fun onToggle() {
        opened = !opened;
    }

    @Composable
    fun renderToggle () {
        Column(modifier = Modifier
            .clickable { onToggle() }
            .fillMaxWidth()
        ) {
            (if (opened) block.seeLess else block.seeMore).forEach { item ->
                Block(
                    block = item,
                    palette = currentBlock.palette,
                    paletteStyles = currentBlock.paletteStyles,
                    additionalTypes = currentBlock.additionalTypes,
                    onDestroy = currentBlock.onDestroy,
                    onClick = currentBlock.onClick,
                    onTriggerEvent = currentBlock.onTriggerEvent,
                )
            }
        }
    }

    Column(
        modifier = Modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
            )
            .fillMaxWidth()
    ) {
        if (block.settings?.seeMorePosition != "after") {
            renderToggle()
        }

        if (opened) {
            Column(modifier = Modifier.fillMaxWidth()) {
                block.content.forEach { item ->
                    Block(
                        block = item,
                        palette = currentBlock.palette,
                        paletteStyles = currentBlock.paletteStyles,
                        additionalTypes = currentBlock.additionalTypes,
                        onDestroy = currentBlock.onDestroy,
                        onClick = currentBlock.onClick,
                        onTriggerEvent = currentBlock.onTriggerEvent,
                    )
                }
            }
        }

        if (block.settings?.seeMorePosition == "after") {
            renderToggle()
        }
    }
}
