package tech.poool.commons.oak.components

import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.oak.data.BlockEmptySpaceItem
import tech.poool.commons.oak.oakStyleToModifier

@Composable
internal fun BlockEmptySpace() {
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockEmptySpaceItem

    Spacer(
        modifier = Modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
            )
            .fillMaxWidth()
    )
}
