package tech.poool.commons.oak.components

import androidx.compose.foundation.layout.ExperimentalLayoutApi
import androidx.compose.foundation.layout.FlowColumn
import androidx.compose.runtime.Composable
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.oak.data.BlockColItem
import tech.poool.commons.oak.oakStyleToModifier

@OptIn(ExperimentalLayoutApi::class)
@Composable
internal fun BlockCol() {
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockColItem

    FlowColumn(
        modifier = currentBlock.modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
                skip = listOf("width", "height"),
            ),
    ) {
        block.content.forEach {
            Block(
                block = it,
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
                additionalTypes = currentBlock.additionalTypes,
                onDestroy = currentBlock.onDestroy,
                onClick = currentBlock.onClick,
                onTriggerEvent = currentBlock.onTriggerEvent,
            )
        }
    }
}
