package tech.poool.commons.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import androidx.compose.ui.platform.LocalUriHandler
import tech.poool.commons.config.BaseConfig
import tech.poool.commons.logger.BaseLogger
import tech.poool.commons.texts.BaseTexts
import tech.poool.commons.variables.BaseVariables

@Composable
internal fun CommonsProvider (
    config: BaseConfig? = null,
    texts: BaseTexts? = null,
    variables: BaseVariables? = null,
    logger: BaseLogger? = null,
    group: String? = null,
    filters: List<String>? = null,
    isReleased: Boolean = false,
    content: @Composable () -> Unit,
){
    val uriHandler = LocalUriHandler.current

    fun openUri(uri: String) {
        try {
            uriHandler.openUri(uri)
        } catch (e: Exception) {
            logger?.e("Error while opening url: $uri", e.toString())
        }
    }

    CompositionLocalProvider (
        LocalCommons provides CommonsProviderData(
            config = config,
            texts = texts,
            variables = variables,
            logger = logger,
            group = group,
            filters = filters,
            isReleased = isReleased,
            openUri = ::openUri,
        ),
        content = content,
    )
}

internal data class CommonsProviderData (
    val config: BaseConfig? = null,
    val texts: BaseTexts? = null,
    val variables: BaseVariables? = null,
    val logger: BaseLogger? = null,
    val group: String? = null,
    val filters: List<String>? = null,
    val isReleased: Boolean = false,
    val openUri: (String) -> Unit = {},
)
