package tech.poool.engage.network.reponses

import com.google.gson.annotations.SerializedName
import tech.poool.commons.oak.data.BlockItem
import tech.poool.commons.oak.data.ColorPalette

internal data class ElementResponse(
    val element: EngageElement,
    val config: EngageElementConfig
)

internal data class EngageElement(
    @SerializedName("_id") val id: String,
    val app: String,
    val content: List<BlockItem> = emptyList(),
    val conditions: List<EngageElementCondition>?,
    val enabled: Boolean,
    val name: String,
    val slug: String,
    @SerializedName("preview_url") val previewUrl: String?,
    val settings: EngageElementSettings,
    val palette: ColorPalette?,
    @SerializedName("palette_styles") val paletteStyles: Map<String, Any?>?,
    @SerializedName("created_at") val createdAt: String,
    @SerializedName("updated_at") val updatedAt: String,
)

internal data class EngageElementConfig(
    val locale: String?,
    @SerializedName("stripe_public_key") val stripePublicKey: String?,
)

internal data class EngageElementSettings (
    @SerializedName("date_format") val dateFormat: String?,
)

internal abstract class EngageElementCondition {
    abstract val type: String
    abstract val hide: Boolean?
}

internal data class EngageElementTargetCondition (
    val value: String,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementBottomSheetConditionValue (
    val enabled: Boolean,
    val closable: Boolean,
)

internal data class EngageElementBottomSheetCondition (
    val value: EngageElementBottomSheetConditionValue,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementModalConditionValue (
    val enabled: Boolean,
    val closable: Boolean,
)

internal data class EngageElementModalCondition (
    val value: EngageElementModalConditionValue,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementPriorityCondition (
    val value: Int,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementVisitsCondition (
    val value: Int,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementVisitsPerDayConditionValue (
    val days: Int,
    val times: Int,
)

internal data class EngageElementVisitsPerDayCondition (
    val value: EngageElementVisitsPerDayConditionValue,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementViewsCondition (
    val value: Int,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementViewsPerDayConditionValue (
    val days: Int,
    val times: Int,
)

internal data class EngageElementViewsPerDayCondition (
    val value: EngageElementViewsPerDayConditionValue,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementUnknownCondition (
    val value: Any?,

    override val type: String,
    override val hide: Boolean?,
): EngageElementCondition()

internal data class EngageElementDelayCondition (
    val value: Int,

    override val type: String,
    override val hide: Boolean,
): EngageElementCondition()

internal data class EngageElementScrollCondition (
    val value: Int,

    override val type: String,
    override val hide: Boolean,
): EngageElementCondition()

