package tech.poool.engage.network.reponses

import com.google.gson.JsonDeserializationContext
import com.google.gson.JsonDeserializer
import com.google.gson.JsonElement
import java.lang.reflect.Type

internal class ConditionDeserializer: JsonDeserializer<EngageElementCondition> {
    override fun deserialize(
        json: JsonElement,
        typeOfT: Type,
        context: JsonDeserializationContext
    ): EngageElementCondition {
        val jsonObject = json.asJsonObject

        return when (jsonObject.get("type").asString) {
            "target" -> EngageElementTargetCondition(
                value = jsonObject.get("value").asString,
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "bottom-sheet" -> EngageElementBottomSheetCondition(
                value = EngageElementBottomSheetConditionValue(
                    enabled = jsonObject.get("value").asJsonObject.get("enabled").asBoolean,
                    closable = jsonObject.get("value").asJsonObject.get("closable").asBoolean
                ),
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "modal" -> EngageElementModalCondition(
                value = EngageElementModalConditionValue(
                    enabled = jsonObject.get("value").asJsonObject.get("enabled").asBoolean,
                    closable = jsonObject.get("value").asJsonObject.get("closable").asBoolean
                ),
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "priority" -> EngageElementPriorityCondition(
                value = jsonObject.get("value")?.asInt ?: 0,
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "visits" -> EngageElementVisitsCondition(
                value = jsonObject.get("value").asInt,
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "visitsPerDay" -> EngageElementVisitsPerDayCondition(
                value = EngageElementVisitsPerDayConditionValue(
                    days = jsonObject.get("value").asJsonObject.get("days").asInt,
                    times = jsonObject.get("value").asJsonObject.get("times").asInt
                ),
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "views" -> EngageElementViewsCondition(
                value = jsonObject.get("value").asInt,
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "viewsPerDay" -> EngageElementViewsPerDayCondition(
                value = EngageElementViewsPerDayConditionValue(
                    days = jsonObject.get("value").asJsonObject.get("days").asInt,
                    times = jsonObject.get("value").asJsonObject.get("times").asInt
                ),
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
            "delay" -> EngageElementDelayCondition(
                value = jsonObject.get("value").asInt,
                hide = jsonObject.get("hide")?.asBoolean ?: false,
                type = jsonObject.get("type").asString
            )
            "scroll" -> EngageElementScrollCondition(
                value = jsonObject.get("value").asInt,
                hide = jsonObject.get("hide")?.asBoolean ?: false,
                type = jsonObject.get("type").asString
            )
            else -> EngageElementUnknownCondition(
                value = jsonObject.get("value"),
                hide = jsonObject.get("hide")?.asBoolean,
                type = jsonObject.get("type").asString
            )
        }
    }
}
