package tech.poool.engage.core

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import kotlinx.coroutines.Deferred
import kotlinx.coroutines.async
import tech.poool.engage.EngageConfig
import tech.poool.engage.EngageDb
import tech.poool.engage.EngageEventsManager
import tech.poool.engage.EngageLogger
import tech.poool.engage.network.reponses.ElementResponse
import tech.poool.engage.network.reponses.AutoCreateResponse
import tech.poool.engage.network.reponses.SentResponse
import tech.poool.engage.network.reponses.SuccessResponse
import tech.poool.engage.EngageTexts
import tech.poool.engage.EngageVariables
import tech.poool.engage.network.EngageNetwork

internal class EngageViewModel(internal val dataConfig: EngageDataConfig) : ViewModel() {
    suspend fun getElement(slug: String): Deferred<ElementResponse?> {
        return viewModelScope.async {
            return@async dataConfig.api.getElement(slug)
        }
    }

    suspend fun autoCreate(filters: List<String>? = null): Deferred<AutoCreateResponse?> {
        return viewModelScope.async {
            return@async dataConfig.api.autoCreate(filters)
        }
    }

    suspend fun sendEvent (data: Map<String, *>): Deferred<SuccessResponse?> {
        return viewModelScope.async {
            return@async dataConfig.api.sendEvent(data)
        }
    }

    suspend fun submitForm (data: Map<String, Any>): Deferred<SentResponse?> {
        return viewModelScope.async {
            return@async dataConfig.api.submitForm(data)
        }
    }
}

internal data class EngageDataConfig(
    var config: EngageConfig,
    var variables: EngageVariables,
    var texts: EngageTexts,
    var events: EngageEventsManager,
    var logger: EngageLogger,
    var api: EngageNetwork,
    var db: EngageDb?,
)
