package tech.poool.engage.compose

import androidx.compose.foundation.ScrollState
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.wrapContentHeight
import androidx.compose.runtime.Composable
import androidx.compose.runtime.DisposableEffect
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateListOf
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import kotlinx.coroutines.channels.BufferOverflow
import kotlinx.coroutines.flow.MutableSharedFlow
import tech.poool.engage.core.EngageManager
import tech.poool.engage.core.shared.LocalEngage
import tech.poool.engage.network.reponses.EngageElement

@Composable
fun EngageElements (
    filters: List<String>? = null,
    autoCommitPageView: Boolean? = false,
    scrollState: ScrollState? = null,
) {
    val (engage, targets) = LocalEngage.current
    var commitedPageview by remember { mutableStateOf(false) }
    val globalElements = remember { mutableStateListOf<EngageElement>() }
    val scrollFlow = remember { mutableStateOf<MutableSharedFlow<Int>>(
        MutableSharedFlow(1, onBufferOverflow = BufferOverflow.DROP_OLDEST)
    ) }

    LaunchedEffect(scrollState?.value) {
        scrollFlow.value.emit(scrollState?.value ?: 0)
    }

    LaunchedEffect(Unit) {
        engage?.autoCreate(
            filters = filters,
            scrollFlow = scrollState?.let { scrollFlow.value },
            scrollHeight = scrollState?.maxValue?.toFloat() ?: 0f,
            onDisplay = { targetId, element ->
                if (targetId == EngageManager.GLOBAL_CONTAINER_ID) {
                    globalElements.add(element)
                    return@autoCreate
                }

                targets[targetId] = targets[targetId]?.let { it + element } ?: listOf(element)
            },
            onHide = { targetId ->
                targets.remove(targetId)
            }
        )

        if (autoCommitPageView == true && !commitedPageview) {
            engage?.commitPageView()
            commitedPageview = true
        }
    }

    DisposableEffect(Unit) {
        onDispose {
            targets.clear()
            globalElements.clear()
        }
    }

    globalElements.forEach {
        Element(
            element = it,
            modifier = Modifier
                .fillMaxWidth()
                .wrapContentHeight(),
        )
    }
}
