package tech.poool.engage.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.LaunchedEffect
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import tech.poool.engage.network.reponses.EngageElement
import tech.poool.engage.core.shared.LocalEngage

@Composable
fun EngageElement (
    slug: String,
    modifier: Modifier = Modifier
) {
    val (engage) = LocalEngage.current
    var element by remember { mutableStateOf<EngageElement?>(null) }

    LaunchedEffect(Unit) {
        engage?.createElement(slug, onDisplay = {
            element = it
        })
    }

    element?.let {
        Element(modifier = modifier, element = it)
    }
}
