package tech.poool.engage.compose

import androidx.compose.runtime.Composable
import tech.poool.commons.compose.LocalForm
import tech.poool.commons.oak.components.Block
import tech.poool.commons.oak.data.BlockButtonItem
import tech.poool.commons.oak.data.BlockItem
import tech.poool.engage.network.reponses.EngageElement

@Composable
internal fun EngageBlock(
    block: BlockItem,
    element: EngageElement,
    onClick: ((eventData: Map<String, Any?>?) -> Unit)? = null,
    onTriggerEvent: ((eventType: String, eventData: Map<String, Any?>?) -> Unit)? = null,
    onDestroy: ((buttonId: String?) -> Unit)? = null,
) {
    val form = LocalForm.current

    Block(
        block = block,
        palette = element.palette,
        paletteStyles = element.paletteStyles,
        shouldDisplay = {
            val displayable =
                if (!form.isSent)
                    it.settings?.displayBeforeSubmit ?: true
                else
                    it.settings?.displayAfterSubmit ?: false

            val isFormRelated = it.type.contains("-field") ||
                    (it is BlockButtonItem && it.action == "submit")

            return@Block !(!displayable || (form.isSent && isFormRelated))
        },
        onDestroy = onDestroy,
        onClick = onClick,
        onTriggerEvent = onTriggerEvent,
    )
}
