package tech.poool.engage

import android.content.Context
import android.view.ViewGroup
import kotlinx.coroutines.flow.MutableSharedFlow
import tech.poool.engage.core.EngageManager
import tech.poool.engage.network.reponses.EngageElement

class Engage(
    appId: String,
    context: Context? = null,
    mode: String? = MODE_VIEWS,
) {
    internal var manager: EngageManager = EngageManager(appId, mode, context)

    fun createElement(slug: String, target: ViewGroup) {
        manager.createElement(slug, target)
    }

    internal fun createElement (
        slug: String,
        onDisplay: ((element: EngageElement) -> Unit)?
    ) {
        manager.createElement(slug, onDisplay = onDisplay)
    }

    fun autoCreate(
        filters: List<String>? = null,
        scrollTarget: ViewGroup? = null,
    ) {
        manager.autoCreate(filters, scrollTarget)
    }

    internal fun autoCreate(
        filters: List<String>? = null,
        scrollFlow: MutableSharedFlow<Int>? = null,
        scrollHeight: Float? = null,
        onDisplay: ((targetId: String, element: EngageElement) -> Unit)? = null,
        onHide: ((targetId: String) -> Unit)? = null,
    ) {
        manager.autoCreate(
            filters = filters,
            scrollFlow = scrollFlow,
            scrollHeight = scrollHeight,
            onDisplay = onDisplay,
            onHide = onHide
        )
    }

    // Config
    fun config(key: String, value: Any? = null, readOnly: Boolean = false): Engage {
        manager.config(key, value, readOnly)

        return this
    }

    fun config(mapConfig: Map<String, Any?>, readOnly: Boolean = false): Engage {
        manager.config(mapConfig, readOnly)

        return this
    }

    // Variables
    fun variables(key: String, value: Any? = null): Engage {
        manager.variables(key, value)

        return this
    }

    fun variables(mapVariables: Map<String, Any?>): Engage {
        manager.variables(mapVariables)

        return this
    }

    // Texts
    fun texts(
        key: String,
        value: String?,
        readOnly: Boolean? = null,
        locale: String? = null
    ): Engage {
        manager.texts(key, value, readOnly, locale)

        return this
    }

    fun texts(
        mapTexts: Map<String, String?>,
        readOnly: Boolean? = null,
        locale: String? = null
    ): Engage {
        manager.texts(mapTexts, readOnly, locale)

        return this
    }

    fun commitPageView (): Engage {
        manager.commitPageView()

        return this
    }

    companion object {
        const val MODE_COMPOSE = "compose"
        const val MODE_VIEWS = "views"
    }
}
