package tech.poool.commons.variables

import tech.poool.commons.helpers.replace

internal open class BaseVariables {
    private val customData: MutableMap<String, String?> = mutableMapOf()

    fun get(key: String): String? = customData[key]

    fun getAll(): Map<String, String?> = customData

    fun setVal(key: String, value: Any?) {
        customData[key] = "$value"
    }

    fun render(str: String, additional: Map<String, Any?> = mapOf()): String {
        val finalReplaces = customData.toMutableMap()

        additional.forEach { (key, value) ->
            finalReplaces[key] = "$value"
        }

        return replace(str, finalReplaces)
    }

    fun reset() {
        customData.clear()
    }
}
