package tech.poool.commons.oak.data

internal data class ColorPalette(
    val id: String,
    val name: String,
    val styles: List<ColorPaletteDefinition>,
    val preview: List<String>?,
    val source: String?,
)

internal abstract class ColorPaletteDefinition {
    abstract val type: String
    abstract val key: String
    abstract val label: String?
}

internal data class ColorPaletteDefinitionColor (
    val value: String,

    override val type: String,
    override val key: String,
    override val label: String?,
): ColorPaletteDefinition()

internal data class ColorPaletteDefinitionUnknown (
    override val type: String,
    override val key: String,
    override val label: String?,
): ColorPaletteDefinition()

internal abstract class ColorPaletteDefinitionValue {
    abstract val type: String
}

internal data class ColorPaletteDefinitionShadowValue (
    val x: String,
    val y: String,
    val blur: String,
    val spread: String,
    val color: String,

    override val type: String,
): ColorPaletteDefinitionValue()

internal data class ColorPaletteDefinitionShadow (
    val value: ColorPaletteDefinitionShadowValue,

    override val type: String,
    override val key: String,
    override val label: String?,
): ColorPaletteDefinition()

internal data class ColorPaletteStyle (
    val type: String,
    val id: String,
    val key: String?,
)
