package tech.poool.commons.oak.data

internal abstract class BlockItem {
    abstract val id: String
    abstract val type: String
    abstract val settings: BlockSettings?
    abstract val styles: BlockStyles?
}

internal abstract class BlockContenableItem : BlockItem() {
    abstract val content: List<BlockItem>
}

internal data class CommonImageSettings(
    val name: String? = null,
    val url: String? = null,
)

internal data class BlockSettings(
    val alignItems: String? = null,
    val flexDirection: String? = null,
    val justifyContent: String? = null,
    val gutters: Boolean? = null,
    val gap: String? = null,

    val showBeforeRelease: Boolean? = null,
    val showAfterRelease: Boolean? = null,
    val displayBeforeSubmit: Boolean? = null,
    val displayAfterSubmit: Boolean? = null,

    val height: String? = null, // ImageBlock, EmptySpaceBlock
    val width: String? = null, // ImageBlock
    val size: String? = null, // ImageBlock
    val textAlign: String? = null, // ImageBlock

//    val buttonType: String? = null, // ButtonBlock

    val seeMorePosition: String? = null, // FoldableBlock

    val bulletImage: CommonImageSettings? = null, // ListBlock

    val alignment: String? = null, // DynamicBlocks
    val destroyOnClick: Boolean? = null, // ImageBlock
)

internal data class BlockStyles(
    // Background
    val backgroundColor: String? = null,
    val backgroundImage: ImageSettings? = null,
    val backgroundPosition: String? = null,
    val backgroundRepeat: String? = null,
    val backgroundSize: String? = null,

    // Spacing
    val marginBottom: String? = null,
    val marginLeft: String? = null,
    val marginRight: String? = null,
    val marginTop: String? = null,
    val paddingBottom: String? = null,
    val paddingLeft: String? = null,
    val paddingRight: String? = null,
    val paddingTop: String? = null,

    // Shadow
    val boxShadowX: String? = null,
    val boxShadowY: String? = null,
    val boxShadowBlur: String? = null,
    val boxShadowSpread: String? = null,
    val boxShadowColor: String? = null,

    // Radius
    val borderTopLeftRadius: String? = null,
    val borderTopRightRadius: String? = null,
    val borderBottomRightRadius: String? = null,
    val borderBottomLeftRadius: String? = null,

    // Border
    val borderWidth: String? = null,
    val borderColor: String? = null,
)

internal data class ImageSettings(
    val name: String? = null,
    val url: String? = null,
)

internal data class BlockRowItem(
    val cols: List<BlockColItem>,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockColItem(
    val content: List<BlockItem>,
    val size: String?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockTitleItem(
    val content: String,
    val headingLevel: String? = null,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockTextItem(
    val content: String,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockButtonItem(
    val content: String,
    val action: String,
    val url: String? = null,
    val event: String? = null,
    val customId: String? = null,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockImageItem(
    val name: String,
    val url: String,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockEmptySpaceItem(
    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal data class BlockListItem(
    val fieldOptions: List<FieldOption>,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
): BlockItem()

internal data class FieldOption(
    val value: String,
)

internal data class BlockFoldableItem(
    val seeMore: List<BlockItem>,
    val seeLess: List<BlockItem>,

    override val id: String,
    override val type: String,
    override val content: List<BlockItem>,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockContenableItem()

internal data class BlockClickableItem(
    val action: String,
    val url: String? = null,
    val event: String? = null,
    val customId: String? = null,

    override val id: String,
    override val type: String,
    override val content: List<BlockItem>,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockContenableItem()

internal data class BlockUnknownItem(
    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockItem()

internal abstract class BlockFieldItem: BlockItem() {
    abstract val fieldName: String?
    abstract val fieldKey: String?
    abstract val fieldType: String?
    abstract val fieldLabel: String?
    abstract val fieldPlaceholder: String?
    abstract val fieldRequired: Boolean?
}

internal abstract class BlockFieldWithOptionsItem: BlockFieldItem() {
    abstract val fieldOptions: List<FormFieldOption>
}

internal data class BlockTextFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockPasswordFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockPhoneFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockMultilineFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockEmailFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockDateFieldItem(
    val minDate: String,
    val maxDate: String,

    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?,
) : BlockFieldItem()

internal data class BlockSelectFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,
    override val fieldOptions: List<FormFieldOption>,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldWithOptionsItem()

internal data class BlockCheckboxFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldItem()

internal data class BlockRadioFieldItem(
    override val fieldName: String?,
    override val fieldKey: String?,
    override val fieldType: String?,
    override val fieldLabel: String?,
    override val fieldPlaceholder: String?,
    override val fieldRequired: Boolean?,
    override val fieldOptions: List<FormFieldOption>,

    override val id: String,
    override val type: String,
    override val settings: BlockSettings?,
    override val styles: BlockStyles?
) : BlockFieldWithOptionsItem()



