package tech.poool.commons.oak.components

import androidx.compose.foundation.clickable
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.width
import androidx.compose.foundation.layout.wrapContentHeight
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import coil.compose.AsyncImage
import coil.decode.SvgDecoder
import coil.request.ImageRequest
import tech.poool.commons.compose.LocalBlock
import tech.poool.commons.oak.data.BlockImageItem
import tech.poool.commons.oak.oakSizeToDp
import tech.poool.commons.oak.oakStyleToModifier
import tech.poool.commons.oak.oakToImageAlignment

@Composable
internal fun BlockImage() {
    val context = LocalContext.current
    val currentBlock = LocalBlock.current
    val block = currentBlock.block as BlockImageItem

    fun onClick () {
        if (block.settings?.destroyOnClick == true) {
            currentBlock.onDestroy?.invoke(null)
        }
    }

    AsyncImage(
        model = ImageRequest.Builder(context = context)
            .data(block.url)
            .decoderFactory(SvgDecoder.Factory())
            .build(),
        contentDescription = "",
        alignment = oakToImageAlignment(block.settings),
        modifier = Modifier
            .oakStyleToModifier(
                settings = block.settings,
                styles = block.styles,
                skip = listOf("width", "height"),
                palette = currentBlock.palette,
                paletteStyles = currentBlock.paletteStyles,
            )
            .clickable { onClick() }
            .then(
                when (block.settings?.size) {
                    "full" -> Modifier
                        .wrapContentSize()
                    "custom" -> Modifier
                        .width(oakSizeToDp(block.settings.width))
                        .height(oakSizeToDp(block.settings.height))
                    else -> Modifier
                        .fillMaxWidth()
                        .wrapContentHeight()
                }
            )
    )
}
