package tech.poool.commons.network.utils

import tech.poool.commons.network.*
import okhttp3.Headers
import okhttp3.Headers.Companion.toHeaders

internal class HeadersProvider(
    platform: String? = null,
) {
    private val defaultHeaders = mutableMapOf(
        CONTENT_TYPE to "application/json",
        TOKEN to "v5",
        PLATFORM to (platform ?: PooolPlatform.ACCESS.value.toString())
    )

    fun getPublicHeaders(): Headers =
        defaultHeaders.toHeaders()

    fun getAuthenticatedHeaders(
        bundleId: String,
        signature: String,
    ): Headers {
        val headers = defaultHeaders.toMutableMap()
        headers[BUNDLE_IDENTIFIER] = bundleId
        headers[SIGNATURE] = signature

        return headers.toHeaders()
    }

    companion object {
        private const val CONTENT_TYPE = "Content-type"
        private const val BUNDLE_IDENTIFIER = "Bundle-Identifier"
        private const val TOKEN = "Token"
        private const val PLATFORM = "Platform"
        private const val SIGNATURE = "Signature"
    }
}
