package tech.poool.commons.network.utils

import android.webkit.CookieManager
import okhttp3.Cookie
import okhttp3.CookieJar
import okhttp3.HttpUrl
import tech.poool.commons.logger.BaseLogger

internal class CookieManager(isCookieEnabled: Boolean, logger: BaseLogger) : CookieJar {
    private val androidCookieManager: CookieManager = CookieManager.getInstance()

    init {
        if (!isCookieEnabled) {
            logger.w("Beware cookies isn't authorized by end user, " +
                    "Paywall usage will be restricted", SCOPE)
        }
    }

    override fun saveFromResponse(url: HttpUrl, cookies: List<Cookie>) {
        androidCookieManager.setCookie(url.host, cookies.joinToString(";"))
    }

    override fun loadForRequest(url: HttpUrl): List<Cookie> {
        val cookies = androidCookieManager.getCookie(url.host)

        return if (cookies != null && cookies.isNotEmpty()) {
            cookies.split(";").mapNotNull {
                Cookie.parse(url, it)
            }
        } else {
            emptyList()
        }
    }

    companion object {
        const val SCOPE = "COOKIES"
    }
}
