package tech.poool.commons.network

import android.util.Base64
import com.google.gson.Gson
import java.net.URLEncoder
import java.security.KeyFactory
import java.security.PublicKey
import java.security.spec.X509EncodedKeySpec
import java.util.*
import javax.crypto.Cipher
import org.json.JSONObject

internal class PooolApiSignature(
    var service: PooolPlatform = PooolPlatform.ACCESS,
    var method: String? = null,
    var url: String? = null,
    k: String,
) {
    private var y: ByteArray = Base64.decode(d(k), Base64.DEFAULT)

    private fun getJsonMap(method: String, url: String, service: Int) = JSONObject().apply {
        put("m", method)
        put("u", URLEncoder.encode(url, "UTF-8"))
        put("s", service)
        put("t", Date().time)
    }.toString()

    fun generateSignature(): String {
        val key: PublicKey = KeyFactory.getInstance("RSA")
            .generatePublic(
                X509EncodedKeySpec(y)
            )

        val cipher = Cipher.getInstance("RSA/ECB/OAEPwithSHA-512andMGF1Padding")
        cipher.init(Cipher.ENCRYPT_MODE, key)

        return Base64.encodeToString(
            cipher.doFinal(getJsonMap(method!!, url!!, service.value).toByteArray()),
            Base64.NO_WRAP
        )
    }

    companion object {
        fun d (p: String): String {
            try {
                val gson = Gson()
                val k = String(Base64.decode(p, Base64.URL_SAFE), Charsets.UTF_8)
                val rwpt = gson.fromJson(k.ifEmpty { "[]" }, Array<String>::class.java).toList()
                val ks = Base64.decode(rwpt.last(), Base64.URL_SAFE).toString(Charsets.UTF_8)
                    .split(" ")
                    .map { it.toInt() }
                val pt = rwpt.dropLast(1)
                val s = pt.sortedBy { ks[pt.indexOf(it)] }
                val j = s.joinToString("")
                val r = Base64.decode(j, Base64.URL_SAFE).toString(Charsets.UTF_8)

                return r
            } catch (e: Exception) {
                return p
            }
        }
    }
}

internal enum class PooolPlatform(val value: Int) {
    UNKNOWN(-1),
    ACCESS(0),
    ENGAGE(14),
}
