package tech.poool.commons.helpers

internal fun replace(text: String, replaces: Map<String, String?>): String {
    return replaces.entries.fold(text) { acc, (key, value) ->
        acc.replace("{$key}", value.toString())
    }
}

internal fun String.stringOrNull(): String? {
    if (this.isEmpty()) {
        return null
    }

    if (this.isBlank()) {
        return null
    }

    return this
}
