package tech.poool.commons.config

internal open class BaseConfig (
    protected val baseData: Map<String, Any?> = mapOf(
        "appId" to null,
    ),
    private val flushable: List<String> = listOf(),
) {
    protected val readOnlies: MutableList<String> = mutableListOf()
    protected val customData: MutableMap<String, Any?> = mutableMapOf()

    private fun isInternalKey (key: String): Boolean {
        return key.matches("^_.*".toRegex())
    }

    fun getAll(): Map<String, Any?> {
        return baseData + customData
    }

    fun <T>get(key: String): T {
        return (customData[normalizeKey(key)] ?: baseData[normalizeKey(key)]) as T
    }

    fun <T>setVal (key: String, value: T?, readOnly: Boolean? = false, isInternal: Boolean? = false): Boolean {
        val camelCaseKey = normalizeKey(key)

        if (
            value == null ||
            (isInternalKey(key) && isInternal == false) ||
            (value is String && value.trim().isEmpty()) ||
            readOnlies.contains(camelCaseKey)
        ) {
            return false
        }

        if (baseData.keys.contains(camelCaseKey)) {
//            TODO: throw exception if value type is wrong

            customData[camelCaseKey] = value

            if ((readOnly != null) && readOnly) {
                readOnlies.add(camelCaseKey)
            }

            return true
        }

        return false
    }

    fun reset() {
        readOnlies.clear()

        baseData.forEach {
            if (it.key in flushable) {
                customData.remove(it.key)
            }
        }
    }

    protected fun normalizeKey(name: String): String {
        if (isInternalKey(name)) {
            return name
        }

        return name
            .replace("([-_][a-z])".toRegex(RegexOption.IGNORE_CASE)) { it.value.uppercase() }
            .replace("-", "")
            .replace("_", "")
    }
}
