package tech.poool.commons.compose

import androidx.compose.runtime.Composable
import androidx.compose.runtime.CompositionLocalProvider
import tech.poool.commons.config.BaseConfig
import tech.poool.commons.logger.BaseLogger
import tech.poool.commons.texts.BaseTexts
import tech.poool.commons.variables.BaseVariables

@Composable
internal fun CommonsProvider (
    config: BaseConfig? = null,
    texts: BaseTexts? = null,
    variables: BaseVariables? = null,
    logger: BaseLogger? = null,
    content: @Composable () -> Unit,
){
    CompositionLocalProvider (
        LocalCommons provides CommonsProviderData(
            config = config,
            texts = texts,
            variables = variables,
            logger = logger,
        ),
        content = content,
    )
}

internal data class CommonsProviderData (
    val config: BaseConfig? = null,
    val texts: BaseTexts? = null,
    val variables: BaseVariables? = null,
    val logger: BaseLogger? = null,
)
