/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import io.reactivex.functions.Function;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class RxThreadLocal<T>
implements Function<Runnable, Runnable> {
    private final Supplier<T> extractor;
    private final Consumer<T> configurer;
    private final Consumer<T> restorer;

    private RxThreadLocal(Supplier<T> extractor, Consumer<T> configurer, Consumer<T> restorer) {
        this.extractor = extractor;
        this.configurer = configurer;
        this.restorer = restorer;
    }

    public static <T> RxThreadLocal<T> from(ThreadLocal<T> threadLocal) {
        return RxThreadLocal.from(threadLocal::get, threadLocal::set);
    }

    public static <T> RxThreadLocal<T> from(Supplier<T> extractor, Consumer<T> setAndRestore) {
        return new RxThreadLocal<T>(extractor, setAndRestore, setAndRestore);
    }

    public static <T> RxThreadLocal<T> from(Supplier<T> extractor, Consumer<T> configurer, Consumer<T> restorer) {
        return new RxThreadLocal<T>(extractor, configurer, restorer);
    }

    public Runnable apply(Runnable delegate) {
        T callerContext = this.extractor.get();
        return () -> {
            T originalContext = this.extractor.get();
            try {
                this.configurer.accept(callerContext);
                delegate.run();
            }
            finally {
                this.restorer.accept(originalContext);
            }
        };
    }
}

