/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import com.google.common.annotations.VisibleForTesting;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.LongFunction;
import javax.annotation.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.http.MediaType;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import tech.picnic.rx.ResourceNotFoundException;

public final class RxSpring4Util {
    public static final Duration NO_TIMEOUT = Duration.ZERO;

    private RxSpring4Util() {
    }

    public static <T> Function<Single<T>, DeferredResult<T>> singleToDeferredResult() {
        return RxSpring4Util.singleToDeferredResult(new DeferredResult());
    }

    public static <T> Function<Single<T>, DeferredResult<T>> singleToDeferredResult(Duration timeout) {
        return RxSpring4Util.singleToDeferredResult(new DeferredResult(Long.valueOf(timeout.toMillis())));
    }

    private static <T> Function<Single<T>, DeferredResult<T>> singleToDeferredResult(DeferredResult<T> deferredResult) {
        return single -> {
            deferredResult.onTimeout(() -> ((Disposable)single.subscribe(arg_0 -> ((DeferredResult)deferredResult).setResult(arg_0), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0))).dispose());
            return deferredResult;
        };
    }

    public static <T> Function<Maybe<T>, DeferredResult<T>> maybeToDeferredResult() {
        return RxSpring4Util.maybeToDeferredResult(new DeferredResult());
    }

    public static <T> Function<Maybe<T>, DeferredResult<T>> maybeToDeferredResult(Duration timeout) {
        return RxSpring4Util.maybeToDeferredResult(new DeferredResult(Long.valueOf(timeout.toMillis())));
    }

    private static <T> Function<Maybe<T>, DeferredResult<T>> maybeToDeferredResult(DeferredResult<T> deferredResult) {
        return maybe -> (DeferredResult)RxSpring4Util.singleToDeferredResult(deferredResult).apply((Object)maybe.switchIfEmpty((SingleSource)Single.defer(() -> Single.error((Throwable)new ResourceNotFoundException()))));
    }

    public static <T, R extends Iterable<T>> Function<Observable<T>, DeferredResult<R>> observableToDeferredResult(Function<? super List<T>, R> collector) {
        return RxSpring4Util.observableToDeferredResult(collector, new DeferredResult());
    }

    public static <T, R extends Iterable<T>> Function<Observable<T>, DeferredResult<R>> observableToDeferredResult(Function<? super List<T>, R> collector, Duration timeout) {
        return RxSpring4Util.observableToDeferredResult(collector, new DeferredResult(Long.valueOf(timeout.toMillis())));
    }

    private static <T, R extends Iterable<T>> Function<Observable<T>, DeferredResult<R>> observableToDeferredResult(Function<? super List<T>, R> collector, DeferredResult<R> deferredResult) {
        return observable -> {
            deferredResult.onTimeout(() -> ((Disposable)observable.toList().map(collector).subscribe(arg_0 -> ((DeferredResult)deferredResult).setResult(arg_0), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0))).dispose());
            return deferredResult;
        };
    }

    public static <T, R extends Iterable<T>> Function<Publisher<T>, DeferredResult<R>> publisherToDeferredResult(Function<? super List<T>, R> collector) {
        return RxSpring4Util.publisherToDeferredResult(collector, new DeferredResult());
    }

    public static <T, R extends Iterable<T>> Function<Publisher<T>, DeferredResult<R>> publisherToDeferredResult(Function<? super List<T>, R> collector, Duration timeout) {
        return RxSpring4Util.publisherToDeferredResult(collector, new DeferredResult(Long.valueOf(timeout.toMillis())));
    }

    private static <T, R extends Iterable<T>> Function<Publisher<T>, DeferredResult<R>> publisherToDeferredResult(Function<? super List<T>, R> collector, DeferredResult<R> deferredResult) {
        return publisher -> {
            deferredResult.onTimeout(() -> ((Disposable)Flowable.fromPublisher((Publisher)publisher).toList().map(collector).subscribe(arg_0 -> ((DeferredResult)deferredResult).setResult(arg_0), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0))).dispose());
            return deferredResult;
        };
    }

    public static Function<Completable, DeferredResult<Void>> completableToDeferredResult() {
        return RxSpring4Util.completableToDeferredResult((DeferredResult<Void>)new DeferredResult());
    }

    public static Function<Completable, DeferredResult<Void>> completableToDeferredResult(Duration timeout) {
        return RxSpring4Util.completableToDeferredResult((DeferredResult<Void>)new DeferredResult(Long.valueOf(timeout.toMillis())));
    }

    private static Function<Completable, DeferredResult<Void>> completableToDeferredResult(DeferredResult<Void> deferredResult) {
        return completable -> {
            deferredResult.onTimeout(() -> ((Disposable)completable.subscribe(() -> deferredResult.setResult(null), arg_0 -> ((DeferredResult)deferredResult).setErrorResult(arg_0))).dispose());
            return deferredResult;
        };
    }

    public static Function<Observable<?>, SseEmitter> observableToSse() {
        return RxSpring4Util.observableToSse(null);
    }

    public static Function<Observable<?>, SseEmitter> observableToSse(@Nullable MediaType mediaType) {
        return RxSpring4Util.observableToSse(mediaType, new SseEmitter());
    }

    public static Function<Observable<?>, SseEmitter> observableToSse(@Nullable MediaType mediaType, Duration timeout) {
        return RxSpring4Util.observableToSse(mediaType, new SseEmitter(Long.valueOf(timeout.toMillis())));
    }

    private static Function<Observable<?>, SseEmitter> observableToSse(@Nullable MediaType mediaType, SseEmitter sseEmitter) {
        return observable -> (SseEmitter)RxSpring4Util.publisherToSse(mediaType, sseEmitter).apply((Object)observable.toFlowable(BackpressureStrategy.BUFFER));
    }

    public static Function<Publisher<?>, SseEmitter> publisherToSse() {
        return RxSpring4Util.publisherToSse((MediaType)null);
    }

    public static <T> Function<Publisher<? extends T>, SseEmitter> publisherToSse(Duration heartbeat, LongFunction<T> heartbeatMapping) {
        return RxSpring4Util.publisherToSse(null, heartbeat, heartbeatMapping);
    }

    public static <T> Function<Publisher<? extends T>, SseEmitter> publisherToSse(@Nullable MediaType mediaType, Duration heartbeat, LongFunction<T> heartbeatMapping) {
        return RxSpring4Util.publisherToSse(mediaType, heartbeat, heartbeatMapping, Schedulers.computation());
    }

    @VisibleForTesting
    static <T> Function<Publisher<? extends T>, SseEmitter> publisherToSse(@Nullable MediaType mediaType, Duration heartbeat, LongFunction<T> heartbeatMapping, Scheduler scheduler) {
        return publisher -> (SseEmitter)Flowable.fromPublisher((Publisher)publisher).publish(flowable -> flowable.mergeWith((Publisher)Flowable.interval((long)heartbeat.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)scheduler).map(heartbeatMapping::apply).takeUntil((Publisher)flowable.ignoreElements().toFlowable()))).to(RxSpring4Util.publisherToSse(mediaType, NO_TIMEOUT));
    }

    public static Function<Publisher<?>, SseEmitter> publisherToSse(@Nullable MediaType mediaType) {
        return RxSpring4Util.publisherToSse(mediaType, new SseEmitter());
    }

    public static Function<Publisher<?>, SseEmitter> publisherToSse(Duration timeout) {
        return RxSpring4Util.publisherToSse(null, timeout);
    }

    public static Function<Publisher<?>, SseEmitter> publisherToSse(@Nullable MediaType mediaType, Duration timeout) {
        return RxSpring4Util.publisherToSse(mediaType, new SseEmitter(Long.valueOf(timeout.toMillis())));
    }

    private static Function<Publisher<?>, SseEmitter> publisherToSse(@Nullable MediaType mediaType, SseEmitter sseEmitter) {
        return publisher -> {
            sseEmitter.onTimeout(() -> ((Disposable)Flowable.fromPublisher((Publisher)publisher).subscribe(o -> sseEmitter.send(o, mediaType), arg_0 -> ((SseEmitter)sseEmitter).completeWithError(arg_0), () -> ((SseEmitter)sseEmitter).complete())).dispose());
            return sseEmitter;
        };
    }
}

