/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import com.google.common.math.LongMath;
import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.internal.functions.Functions;
import io.reactivex.schedulers.Schedulers;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryStrategy
implements Function<Flowable<Throwable>, Flowable<?>> {
    private static final Duration STOP_RETRYING = Duration.ofMillis(-1L);
    private static final Logger LOG = LoggerFactory.getLogger(RetryStrategy.class);
    private final Predicate<Throwable> filter;
    private final Flowable<Duration> backoffDelays;
    private final long maxRetries;
    private final Scheduler backoffScheduler;
    @Nullable
    private final String operationName;

    RetryStrategy(Builder builder) {
        this.filter = builder.filter;
        this.backoffDelays = builder.backoffDelays;
        this.maxRetries = builder.maxRetries;
        this.backoffScheduler = builder.backoffScheduler;
        this.operationName = builder.operationName;
    }

    public Flowable<?> apply(Flowable<Throwable> errors) {
        return errors.zipWith(this.getCappedDelays(), (e, d) -> !d.isNegative() && this.filter.test((Throwable)e) ? this.retry((Throwable)e, (Duration)d) : Flowable.error((Throwable)e)).flatMap(Functions.identity());
    }

    private Flowable<Duration> getCappedDelays() {
        return (this.maxRetries <= 0L ? this.backoffDelays : this.backoffDelays.take(this.maxRetries)).concatWith((Publisher)Flowable.just((Object)STOP_RETRYING));
    }

    private Flowable<?> retry(Throwable error, Duration delay) {
        if (this.operationName != null) {
            LOG.info("Will retry failed operation '{}': {}", (Object)this.operationName, (Object)error.getMessage());
        }
        return Flowable.timer((long)delay.toMillis(), (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)this.backoffScheduler);
    }

    public static Builder always() {
        return new Builder(t -> true);
    }

    @SafeVarargs
    public static Builder ifInstanceOf(Class<? extends Throwable> ... classes) {
        return new Builder(t -> Arrays.stream(classes).anyMatch(c -> c.isInstance(t)));
    }

    public static Builder onlyIf(Predicate<Throwable> predicate) {
        return new Builder(predicate);
    }

    @NotThreadSafe
    public static final class Builder {
        private final Predicate<Throwable> filter;
        private Flowable<Duration> backoffDelays = Flowable.just((Object)Duration.ZERO).repeat();
        private long maxRetries = 0L;
        private Scheduler backoffScheduler = Schedulers.computation();
        @Nullable
        private String operationName = null;

        Builder(Predicate<Throwable> filter) {
            this.filter = filter;
        }

        public Builder exponentialBackoff(Duration initialDelay) {
            return this.customBackoff(Builder.getExponentialDelays(initialDelay));
        }

        public Builder boundedExponentialBackoff(Duration initialDelay, Duration maxBackoffDelay) {
            return this.customBackoff((Flowable<Duration>)Builder.getExponentialDelays(initialDelay).map(delay -> Collections.min(Arrays.asList(delay, maxBackoffDelay))));
        }

        private static Flowable<Duration> getExponentialDelays(Duration initialDelay) {
            return Flowable.just((Object)2).repeat().scan((Object)initialDelay.toMillis(), LongMath::saturatedMultiply).map(Duration::ofMillis);
        }

        public Builder fixedBackoff(Duration delay) {
            return this.customBackoff((Flowable<Duration>)Flowable.just((Object)delay).repeat());
        }

        public Builder randomBackoff(Duration maxDelay) {
            long maxDelayMillis = maxDelay.toMillis() + 1L;
            return this.customBackoff((Flowable<Duration>)Flowable.fromCallable(() -> Duration.ofMillis(ThreadLocalRandom.current().nextLong(maxDelayMillis))).repeat());
        }

        public Builder customBackoff(Flowable<Duration> delays) {
            this.backoffDelays = delays;
            return this;
        }

        public Builder withBackoffScheduler(Scheduler scheduler) {
            this.backoffScheduler = scheduler;
            return this;
        }

        public Builder times(long maxNumRetries) {
            this.maxRetries = maxNumRetries;
            return this;
        }

        public Builder logAs(String name) {
            this.operationName = name;
            return this;
        }

        public RetryStrategy build() {
            return new RetryStrategy(this);
        }
    }
}

