/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import com.google.common.collect.Lists;
import io.reactivex.functions.Function;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.Arrays;
import java.util.List;
import tech.picnic.rx.RxThreadLocal;

public final class PicnicRxPlugins {
    private PicnicRxPlugins() {
    }

    public static void configureContextPropagation(RxThreadLocal<?> ... rxThreadLocals) {
        PicnicRxPlugins.configureContextPropagation(Arrays.asList(rxThreadLocals));
    }

    public static void configureContextPropagation(List<RxThreadLocal<?>> rxThreadLocals) {
        RxJavaPlugins.setScheduleHandler(PicnicRxPlugins.compose(rxThreadLocals));
    }

    private static Function<Runnable, Runnable> compose(List<? extends Function<? super Runnable, ? extends Runnable>> functions) {
        return r -> {
            Runnable composition = r;
            for (Function f : Lists.reverse((List)functions)) {
                composition = (Runnable)f.apply((Object)composition);
            }
            return composition;
        };
    }

    public static void unsetContextPropagation() {
        if (!RxJavaPlugins.isLockdown()) {
            RxJavaPlugins.setScheduleHandler(null);
        }
    }
}

