/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableList;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.schedulers.TestScheduler;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matchers;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.test.web.servlet.setup.StandaloneMockMvcBuilder;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import tech.picnic.rx.RxSpring4Util;

@Test(singleThreaded=true)
public final class RxSpring4UtilTest {
    private final TestScheduler testScheduler = new TestScheduler();
    private MockMvc mockMvc;

    @BeforeMethod
    public void setup() {
        this.mockMvc = ((StandaloneMockMvcBuilder)MockMvcBuilders.standaloneSetup((Object[])new Object[]{new TestController(this.testScheduler)}).alwaysExpect(MockMvcResultMatchers.request().asyncStarted())).setMessageConverters(new HttpMessageConverter[]{new StringHttpMessageConverter(), new MappingJackson2HttpMessageConverter(), new MappingJackson2XmlHttpMessageConverter()}).build();
    }

    public void testSingleToDeferredResult() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/singleToDeferredResult?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)"foo"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/singleToDeferredResult?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testMaybeToDeferredResult() throws Exception {
        Assert.assertNull((Object)this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/maybeToDeferredResult", (Object[])new Object[0])).andReturn().getAsyncResult());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/maybeToDeferredResult?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)"foo"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/maybeToDeferredResult?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testObservableToDeferredResult() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToDeferredResult?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of((Object)"foo")));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToDeferredResult?value=bar&repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of((Object)"bar", (Object)"bar")));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToDeferredResult?value=baz&repeat=0", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToDeferredResult?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testPublisherToDeferredResult() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToDeferredResult?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of((Object)"foo")));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToDeferredResult?value=bar&repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of((Object)"bar", (Object)"bar")));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToDeferredResult?value=baz&repeat=0", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult((Object)ImmutableList.of()));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToDeferredResult?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testCompletableToDeferredResult() throws Exception {
        Assert.assertNull((Object)this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/completableToDeferredResult?fail=false", (Object[])new Object[0])).andReturn().getAsyncResult());
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/completableToDeferredResult?fail=true", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testObservableToSse() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToSse?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:foo\n\n"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToSse?value=bar&repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:bar\n\ndata:bar\n\n"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToSse?value=baz&repeat=0", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string(""));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/observableToSse?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testPublisherToSse() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse?value=foo", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:foo\n\n"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse?value=bar&repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:bar\n\ndata:bar\n\n"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse?value=baz&repeat=0", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string(""));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse?value=error", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.request().asyncResult(Matchers.instanceOf(IllegalArgumentException.class)));
    }

    public void testPublisherToSseWithKeepAlive() throws Exception {
        this.testScheduler.advanceTimeTo(0L, TimeUnit.MILLISECONDS);
        MockHttpServletResponse response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse/with-keep-alive?value=foo&repeat=2&interval=250", (Object[])new Object[0])).andReturn().getResponse();
        this.testScheduler.advanceTimeTo(99L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"");
        this.testScheduler.advanceTimeTo(249L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\ndata:keep-alive #1\n\n");
        this.testScheduler.advanceTimeTo(250L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\ndata:keep-alive #1\n\ndata:foo\n\n");
        this.testScheduler.advanceTimeTo(300L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\ndata:keep-alive #1\n\ndata:foo\n\ndata:keep-alive #2\n\n");
        this.testScheduler.advanceTimeTo(1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\ndata:keep-alive #1\n\ndata:foo\n\ndata:keep-alive #2\n\ndata:keep-alive #3\n\ndata:foo\n\n");
    }

    public void testPublisherToSseWithKeepAliveAndError() throws Exception {
        this.testScheduler.advanceTimeTo(0L, TimeUnit.MILLISECONDS);
        MockHttpServletResponse response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse/with-keep-alive?value=error&repeat=1&interval=150", (Object[])new Object[0])).andReturn().getResponse();
        this.testScheduler.advanceTimeTo(149L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\n");
        this.testScheduler.advanceTimeTo(200L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((String)response.getContentAsString(), (String)"data:keep-alive #0\n\n");
    }

    public void testPublisherToSseWithComplexObject() throws Exception {
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse/with-complex-object?repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:{\"name\":\"foo\",\"age\":0}\n\ndata:{\"name\":\"foo\",\"age\":1}\n\n"));
        this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/publisherToSse/with-complex-object?mediaType=application/xml&repeat=2", (Object[])new Object[0])).andExpect(MockMvcResultMatchers.content().string("data:<Person><name>foo</name><age>0</age></Person>\n\ndata:<Person><name>foo</name><age>1</age></Person>\n\n"));
    }

    @RestController
    static class TestController {
        private final TestScheduler testScheduler;

        TestController(TestScheduler testScheduler) {
            this.testScheduler = testScheduler;
        }

        @GetMapping(value={"/singleToDeferredResult"})
        public DeferredResult<String> withSingleToDeferredResult(@RequestParam String value) {
            return (DeferredResult)Single.fromCallable(TestController.defer(value, "error")).to(RxSpring4Util.singleToDeferredResult());
        }

        @GetMapping(value={"/maybeToDeferredResult"})
        public DeferredResult<String> withMaybeToDeferredResult(@RequestParam Optional<String> value) {
            return (DeferredResult)Maybe.fromCallable(TestController.defer(value.orElse(null), "error")).to(RxSpring4Util.maybeToDeferredResult());
        }

        @GetMapping(value={"/observableToDeferredResult"})
        public DeferredResult<ImmutableList<String>> withObservableToDeferredResult(@RequestParam String value, @RequestParam(defaultValue="1") int repeat) {
            return (DeferredResult)Observable.defer(() -> Observable.just((Object)TestController.defer(value, "error").call())).repeat((long)repeat).to(RxSpring4Util.observableToDeferredResult(ImmutableList::copyOf));
        }

        @GetMapping(value={"/publisherToDeferredResult"})
        public DeferredResult<ImmutableList<String>> withPublisherToDeferredResult(@RequestParam String value, @RequestParam(defaultValue="1") int repeat) {
            return (DeferredResult)Flowable.defer(() -> Flowable.just((Object)TestController.defer(value, "error").call())).repeat((long)repeat).to(RxSpring4Util.publisherToDeferredResult(ImmutableList::copyOf));
        }

        @GetMapping(value={"/completableToDeferredResult"})
        public DeferredResult<Void> withPublisherToDeferredResult(@RequestParam boolean fail) {
            return (DeferredResult)Completable.defer(() -> fail ? Completable.error((Throwable)new IllegalArgumentException()) : Completable.complete()).to(RxSpring4Util.completableToDeferredResult());
        }

        @GetMapping(value={"/observableToSse"})
        public SseEmitter withObservableToSse(@RequestParam String value, @RequestParam(defaultValue="1") int repeat) {
            return (SseEmitter)Observable.defer(() -> Observable.just((Object)TestController.defer(value, "error").call())).repeat((long)repeat).to(RxSpring4Util.observableToSse());
        }

        @GetMapping(value={"/publisherToSse"})
        public SseEmitter withPublisherToSse(@RequestParam String value, @RequestParam(defaultValue="1") int repeat) {
            return (SseEmitter)Flowable.defer(() -> Flowable.just((Object)TestController.defer(value, "error").call())).repeat((long)repeat).to(RxSpring4Util.publisherToSse());
        }

        @GetMapping(value={"/publisherToSse/with-keep-alive"})
        public SseEmitter withPublisherToSseAndKeepAlive(@RequestParam String value, @RequestParam int repeat, @RequestParam int interval) {
            return (SseEmitter)Flowable.interval((long)interval, (TimeUnit)TimeUnit.MILLISECONDS, (Scheduler)this.testScheduler).map(i -> TestController.defer(value, "error").call()).limit((long)repeat).to(RxSpring4Util.publisherToSse(null, (Duration)Duration.ofMillis(100L), i -> "keep-alive #" + i, (Scheduler)this.testScheduler));
        }

        @GetMapping(value={"/publisherToSse/with-complex-object"})
        public SseEmitter withPublisherToSseAndComplexObject(@RequestParam Optional<String> mediaType, @RequestParam int repeat) {
            return (SseEmitter)Flowable.range((int)0, (int)repeat).map(i -> new Person("foo", (int)i)).to(RxSpring4Util.publisherToSse((MediaType)mediaType.map(MediaType::valueOf).orElse(null)));
        }

        private static <T> Callable<T> defer(T value, T errorValue) {
            return () -> {
                if (errorValue.equals(value)) {
                    throw new IllegalArgumentException("Error!");
                }
                return value;
            };
        }
    }

    static class Person {
        private final String name;
        private final int age;

        @JsonCreator
        Person(String name, int age) {
            this.name = name;
            this.age = age;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }
    }
}

