/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.rx;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.TestScheduler;
import io.reactivex.subscribers.TestSubscriber;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.testng.Assert;
import org.testng.annotations.Test;
import tech.picnic.rx.RetryStrategy;

@Test
public final class RetryStrategyTest {
    public void testOnlyIf() throws Exception {
        ((TestSubscriber)((TestSubscriber)RetryStrategyTest.errorSource(2).retryWhen((Function)RetryStrategy.onlyIf(e -> e instanceof RuntimeException && "Error #1".equals(e.getMessage())).build()).test().await()).assertError(RuntimeException.class)).assertErrorMessage("Error #2");
        ((TestSubscriber)((TestSubscriber)RetryStrategyTest.errorSource(1).retryWhen((Function)RetryStrategy.onlyIf(e -> e instanceof Error).build()).test().await()).assertError(RuntimeException.class)).assertErrorMessage("Error #1");
    }

    public void testExponentialBackoff() throws Exception {
        AtomicInteger retries = new AtomicInteger();
        TestScheduler scheduler = new TestScheduler();
        TestSubscriber test = RetryStrategyTest.errorSource(10).doOnSubscribe(d -> retries.incrementAndGet()).retryWhen((Function)RetryStrategy.always().withBackoffScheduler((Scheduler)scheduler).exponentialBackoff(Duration.ofMillis(100L)).build()).test();
        ((TestSubscriber)test.assertNotTerminated()).assertNoValues();
        int i = 1;
        int d2 = 100;
        int t = 0;
        while (i <= 10) {
            scheduler.advanceTimeTo((long)t, TimeUnit.MILLISECONDS);
            ((TestSubscriber)test.assertNotTerminated()).assertNoValues();
            Assert.assertEquals((int)retries.get(), (int)i);
            scheduler.advanceTimeBy((long)(d2 - 1), TimeUnit.MILLISECONDS);
            ((TestSubscriber)test.assertNotTerminated()).assertNoValues();
            Assert.assertEquals((int)retries.get(), (int)i);
            ++i;
            t += d2;
            d2 *= 2;
        }
        scheduler.advanceTimeBy(1L, TimeUnit.MILLISECONDS);
        ((TestSubscriber)test.assertValue((Object)11)).assertComplete();
    }

    public void testFixedBackoff() throws Exception {
        TestScheduler scheduler = new TestScheduler();
        TestSubscriber test = RetryStrategyTest.errorSource(10).retryWhen((Function)RetryStrategy.always().withBackoffScheduler((Scheduler)scheduler).fixedBackoff(Duration.ofMillis(500L)).build()).test();
        scheduler.advanceTimeTo(4999L, TimeUnit.MILLISECONDS);
        ((TestSubscriber)test.assertNotTerminated()).assertNoValues();
        scheduler.advanceTimeTo(5000L, TimeUnit.MILLISECONDS);
        ((TestSubscriber)test.assertValue((Object)11)).assertComplete();
    }

    public void testCustomBackoff() throws Exception {
        TestScheduler scheduler = new TestScheduler();
        TestSubscriber test = RetryStrategyTest.errorSource(10).retryWhen((Function)RetryStrategy.always().withBackoffScheduler((Scheduler)scheduler).customBackoff(Flowable.just((Object)Duration.ofMillis(10L), (Object)Duration.ofMillis(20L))).build()).test();
        scheduler.advanceTimeTo(29L, TimeUnit.MILLISECONDS);
        ((TestSubscriber)test.assertNotTerminated()).assertNoValues();
        scheduler.advanceTimeTo(30L, TimeUnit.MILLISECONDS);
        ((TestSubscriber)test.assertError(RuntimeException.class)).assertErrorMessage("Error #3");
    }

    public void testTimes() throws Exception {
        ((TestSubscriber)((TestSubscriber)RetryStrategyTest.errorSource(10).retryWhen((Function)RetryStrategy.always().times(5L).build()).test().await()).assertError(RuntimeException.class)).assertErrorMessage("Error #6");
        ((TestSubscriber)((TestSubscriber)RetryStrategyTest.errorSource(10).retryWhen((Function)RetryStrategy.always().times(10L).build()).test().await()).assertValue((Object)11)).assertComplete();
    }

    private static Flowable<Integer> errorSource(int errors) {
        AtomicInteger count = new AtomicInteger();
        return Flowable.fromCallable(count::incrementAndGet).map(i -> {
            if (i <= errors) {
                throw new RuntimeException("Error #" + i);
            }
            return i;
        });
    }
}

