/** */
package tech.pardus.multitenant.datasource.entity.converters;

import java.sql.Date;
import java.time.LocalDate;

import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

/**
 * @author deniz.toktay
 * @since Dec 29, 2020
 */
@Converter(autoApply = true)
public class LocalDateSqlAttributeConverter implements AttributeConverter<LocalDate, Date> {

  @Override
  public Date convertToDatabaseColumn(LocalDate attribute) {
    return attribute == null ? null : Date.valueOf(attribute);
  }

  @Override
  public LocalDate convertToEntityAttribute(Date dbData) {
    return dbData == null ? null : dbData.toLocalDate();
  }
}
