package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.lengthBoundsRestrictions
import tech.ostack.kform.schemas.util.patternRestrictions

/** Schema representing values of type [String]. */
public open class StringSchema(
    validations: Iterable<Validation<String>> = emptyList(),
    override val initialValue: String = "",
) : AbstractSimpleSchema<String>(validations) {
    public constructor(
        vararg validations: Validation<String>,
        initialValue: String = "",
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            String::class,
            restrictions =
                commonRestrictions(validations) +
                    lengthBoundsRestrictions(validations) +
                    patternRestrictions(validations),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance("") == true

    override suspend fun fromAny(value: Any?): String = value.toString()
}
