package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing numeric values of type [Int]. */
public open class IntSchema(
    validations: Iterable<Validation<Int>> = emptyList(),
    override val initialValue: Int = 0,
) : AbstractSimpleSchema<Int>(validations) {
    public constructor(
        vararg validations: Validation<Int>,
        initialValue: Int = 0,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Int::class,
            restrictions =
                commonRestrictions(validations) +
                    comparableBoundsRestrictions(validations, Int.MIN_VALUE, Int.MAX_VALUE),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0) == true

    override suspend fun fromAny(value: Any?): Int =
        when (value) {
            is Number -> value.toInt()
            is String -> value.toInt()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Int.")
        }
}
