package tech.ostack.kform.schemas

import kotlin.reflect.KClass
import kotlin.reflect.KType
import tech.ostack.kform.TypeInfo
import tech.ostack.kform.Validation
import tech.ostack.kform.schemas.util.commonRestrictions
import tech.ostack.kform.schemas.util.comparableBoundsRestrictions

/** Schema representing numeric values of type [Float]. */
public open class FloatSchema(
    validations: Iterable<Validation<Float>> = emptyList(),
    override val initialValue: Float = 0f,
) : AbstractSimpleSchema<Float>(validations) {
    public constructor(
        vararg validations: Validation<Float>,
        initialValue: Float = 0f,
    ) : this(validations.asIterable(), initialValue)

    override val typeInfo: TypeInfo =
        TypeInfo(
            Float::class,
            restrictions =
                commonRestrictions(validations) + comparableBoundsRestrictions(validations),
        )

    override fun assignableTo(type: KType): Boolean =
        (type.classifier as? KClass<*>)?.isInstance(0f) == true

    override suspend fun fromAny(value: Any?): Float =
        when (value) {
            is Number -> value.toFloat()
            is String -> value.toFloat()
            else -> throw IllegalArgumentException("Cannot convert value '$value' to Float.")
        }
}
